#ifndef TBAPI_H 
#define TBAPI_H 

//experimental, is this appropriate here? caused problems in CE5 GCA 15/07/11
//#include <time.h>

#undef TBAPIDLLPFX 
#ifndef TBCHAR 
#ifdef UNDER_CE
#define TBCHAR wchar_t
#define _TBT(x)      L ## x
#else
#define TBCHAR char
#define _TBT 
#endif
#endif
//

#ifndef _LINUX_

#ifndef DWORD 
#define DWORD unsigned long // on Linux conflicts with the already typedef'd version. In g++ the two types behave differently and using the 
#endif                      // define version breaks the DWORD(0) usage throughout the api

#endif

#ifndef WORD 
#define WORD unsigned short
#endif                      

#ifndef ULONG 
#define ULONG unsigned long
#endif

#ifndef UCHAR 
#define UCHAR unsigned char
#endif

#ifndef BYTE 
#define BYTE unsigned char
#endif

#ifndef BOOL  
#define BOOL int
#endif

#ifndef LPCTSTR 
#ifdef UNDER_CE
#define LPCTSTR const WCHAR *
#else
#define LPCTSTR const char *
#endif
#endif

#ifndef LPCSTR 
#define LPCSTR const char *
#endif

#ifndef LPTSTR 
#ifdef UNDER_CE
#define LPTSTR WCHAR *
#else
#define LPTSTR char *
#endif
#endif

#ifdef UNDER_CE
  #define t_string wstring
#else
  #define t_string string
#endif

 
#ifdef INTERNALAPI
// this mode is for internal touch-base use 
#ifdef _WINDOWS
#pragma comment(linker,"/nodefaultlib:libcmt") 
#pragma comment(linker,"/nodefaultlib:libcmtd") 
#pragma comment(lib,"setupapi.lib")
#endif
#ifdef _DEBUG 
#ifndef NOACE
#ifdef _AMD64_
#pragma comment(lib,"../../../ace_updd_5.6.2/ACE_wrappers/lib/x64/aced.lib") 
#else
#pragma comment(lib,"../../../ace_updd_5.6.2/ACE_wrappers/lib/x86/aced.lib") 
#endif
#endif 
#pragma comment(linker,"/defaultlib:msvcrtd") 
#pragma comment(linker,"/nodefaultlib:msvcrt") 
#else
#ifndef NOACE
#ifdef _AMD64_
#pragma comment(lib,"../../../ace_updd_5.6.2/ACE_wrappers/lib/x64/ace.lib") 
#else
#ifdef _WINDOWS
#pragma comment(lib,"../../../ace_updd_5.6.2/ACE_wrappers/lib/x86/ace.lib") 
#endif 
#endif 
#endif 
// In VS2005 build, these two lines cause a number of link errors
//#pragma comment(linker,"/defaultlib:msvcrt") 
//#pragma comment(linker,"/nodefaultlib:msvcrtd") 
#endif 
#endif 

#ifdef TBAPIDLL_EXPORTS 
#define TBAPI __declspec(dllexport) _stdcall
#pragma warning(disable:4518)            
//#define TBAPIDLLPFX  
#endif

#ifdef TBAPIDLL_IMPORTS 
#define TBAPI __declspec(dllimport) _stdcall
#pragma warning(disable:4518)            
#define TBAPIDLLPFX 
#endif 

#ifndef TBAPI 
#ifdef _LINUX_
#define TBAPI 
#endif
#endif


#ifndef TBAPI 
#ifndef _VXWORKS_
#define TBAPI _stdcall
#endif
#endif

#ifdef _VXWORKS_
#define _stdcall 
#define __cdecl 
#define _cdecl 
#define TBAPI 
#endif

#ifdef _SOLARIS_
#define _stdcall 
#define __cdecl 
#define _cdecl 
#endif

#ifdef __cplusplus
extern "C"
{
#endif
// constants that define data types to be read
// can be ORed, eg _ReadDataTypeXY | _ReadDataTypeEvent
// to read pointer co-ordinates and button events

#define _ReadDataTypeXY 0x0001    // pointer co-ordinates
#define _ReadDataTypeEvent 0x0002  // button state changes
#define _ReadDataTypeHardware 0x0004 // changes of hardware registers
#define _ReadDataTypeData 0x0008  // non-pointer data
#define _ReadDataTypeToolbar 0x0010  // toolbar events 
#define _ReadDataSettings 0x0020  // notifications of changes to driver parameters 
#define _ReadDataTypeSelector 0x0040 // notifications of change in event selector state
#define _ReadDataTypeZ 0x0080   // notifications of change in Z values
#define _ReadDataTypeRelative 0x0100 // notifications or relative movement
#define _ReadDataTypeUnload 0x0200  // the driver is about to attempt an unload 
#define _ReadDataTypeRawEvent 0x0400 // a change in state of an internal event handler has occured 
#define _ReadDataTypeMacroEvent 0x0800 // a macro event has occured (currently completions only) 
#define _ReadDataTypeXYCal 0x1000    // same as _ReadDataTypeXY but not masked by toolbars and surrounds used for calibration 
#define _ReadDataTypeDynamicAdd 0x2000 // Driver reports that a controller must be dynamicaly added 
#define _ReadDataTypeInteractiveTouch 0x4000 // mouse pointer state events for interactive touch mode
#define _ReadDataTypeIPConnection 0x8000 // upddip connection
#define _ReadDataTypeNetworkData 0x10000  // network data
#define _ReadDataTypeForwardNetworkData 0x20000  // network data
#define _ReadDataTypeZytronicHack 0x40000  // special for zytronic
#define _ReadDataTypeDeviceChanged 0x80000  // notify tbdaemon of a device change 
//#define _ReadDataTypeSound 0x100000  // request a beep in user mode
#define _Reserved 0x200000  // see internalapi.h
#define _ReadDataTypeReadEEPROM 0x400000  // a new eeprom based device was plugged in
#define _ReadDataTypePlayUPDDSound 0x800000  // play a sound defined for this device
#define _ReadDataTypeMouseEvent 0x1000000  // raw data sent to mouse port 
#define _ReadDataTypeSecBlock 0x2000000  // touch data was received when a security block was in place 

#define TBNEW_STYLE -1  
#define HTBSTYLE int		
#define HTBSTENCIL int		
#define HTBDEVICE unsigned char
#define HTBSTYLUS unsigned char
//#define HTBBUNDLE unsigned char
//#define HTBVOID unsigned short
#define TB_INVALID_HANDLE_VALUE 0x00

//#pragma warning(disable: 4091) 

// the following struct defines a calibration style 

#define MAXSTYLENAME 32
#define MAXCALPOINTS 25

#ifndef TBAPIDEFNS_H 
#define TBAPIDEFNS_H 

struct _CalStyle
{
 TBCHAR theName[MAXSTYLENAME];
 DWORD theTransparent;
 DWORD theNPoints;
 DWORD theRotation;
 DWORD theStartPct;
 DWORD theTimeout;
 struct 
 {
  DWORD x;
  DWORD y;
 }thePoints[MAXCALPOINTS];
};

// this enum represents macro completion states 

enum _MacroState 
{
	eMacroNotStarted,
	eStarted,
	eTimedOut,
	eFailed,
	eSyntax,
	eNotSupported,
	eNak,
	eNoMacro,			// anything that follows  this must represent "OK" 
	eComplete,
	eUnknown
};

#define TB_MOUSE_LEFT_BUTTON_DOWN   0x0001  // Left Button changed to down.
#define TB_MOUSE_LEFT_BUTTON_UP     0x0002  // Left Button changed to up.
#define TB_MOUSE_RIGHT_BUTTON_DOWN  0x0004  // Right Button changed to down.
#define TB_MOUSE_RIGHT_BUTTON_UP    0x0008  // Right Button changed to up.
#define TB_MOUSE_MIDDLE_BUTTON_DOWN 0x0010  // Middle Button changed to down.
#define TB_MOUSE_MIDDLE_BUTTON_UP   0x0020  // Middle Button changed to up.

struct _mouseEvent
{
  unsigned short buttons; // button state change from the TB_MOUSE_xxx constants above
  BOOL absolute;  // true = absolute, false = relative
  // x & y below hold relative or absolute position
  // absolute co-ordinates are in the range 0-0xffff for monitor 1, other monitors extend this range based on position and size
  long x;         
  long y;
  int stylus; // zero based stylus number 
};

// following struct defines data that can be read from updd interface

struct _PointerData
{
	unsigned long tick;		// indicates relative time data was read
	union _pd 		// only one of the following is used, as indicated by the "type" member
	{
		struct _xy		// co-ordinate data
		{	
			unsigned long rawx;	// the raw X value from the controller (normalised) 
			unsigned long rawy;	// the raw Y value from the controller (normalised) 
			unsigned long calx; // the corresponding calibrated value 
			unsigned long caly;	//           --- ditto ---
		}xy;				
		struct _z		// pressure data
		{	
			unsigned long rawz;	// the raw z value from the controller
		}z;				
		struct _event		// mouse button state change
		{
			unsigned char left;  	// state of left button 1 = pressed
      unsigned char right;    // state of right button 1 = pressed   
      bool timed;
   
  }event;                             
  struct _data  // non-pointer data
  {
    UCHAR byte[64];
  }data;
  struct _toolbar  // a toolbar area was touched 
  {
   unsigned short toolbarid; // the identifier of the toolbar 
   unsigned short row;  // row # of button
   unsigned short col;  // column number of button
  }toolbar;
  struct _hardware // a hardware event 
  {
   unsigned char hwByte;  // the new value of the register   
   unsigned char hwOfst;  // the position of the register relative to the port base address
  }hardware;
  struct _selector  // change in the state of the event selector
  {
   unsigned char bAlt; // TRUE = Alternate event set selected 
  }selector;                             
  struct _rawEvent   // raw event change
  {
   int eventHandle;  // handle to event object if -1 this callback indicates the end of 
         // event bit processing for the packet - and the state flag below is not  populated 
   unsigned char state;   // state of event 1 = set
   bool timed;
   bool wasToolbarTouch;
   short gesture;
  }rawEvent;                             
  struct _macroEvent   // macro event 
  {
   _MacroState status;  // currently macro events only occur on macro completion 
         // this is the completion status 
  }macroEvent;                             
  struct _interactiveTouch  // co-ordinate data 
  {  
   unsigned long ticks;   // ticks since touch  
   unsigned long maxTicks; // tick count at which icon change will occur  
  }interactiveTouch ;     
  struct _ipconnection  // client data 
  {  
   /*char hostname[128]; 
   char ipaddress[128];*/ 
    char hostname[4]; 
    char ipaddress[4]; 
  }ipconnection;     
  struct _networkdata  // network data 
  {
   DWORD numPackets;   // number of packets in a datastream
   DWORD packetNumber; // current packet number
   DWORD uncompressedSize; // size of complete data uncompressed
   //char data[256];     // data 
   char data[4]; 
  }networkdata;
  struct _addUSB
  {
   DWORD vid; 
   DWORD pid; 
   DWORD ref; 
  }addUSB;
  struct _sound
  {
   DWORD pitch; 
   DWORD duration; 
   DWORD ref; 
  }sound;
  struct _mouseEvent mouseEvent;

 }pd; 
 HTBDEVICE hDevice;   // device handle

 HTBSTYLUS hStylus; // stylus handle

 unsigned long type;   // data type

};

#endif // TBAPIDEFNS_H

#ifndef DRIVERSTRINGS	

#ifdef MACX
#define _stdcall 
#define __cdecl 
#define _cdecl 
#endif
//function pointer definition for data callback 
typedef void (_stdcall *TB_DATA_CALL)(unsigned long context, _PointerData* data);
	  
// prototypes 

// ** MIGRATION NOTE ** in UPDD versions prior to 4.1 TBApiInit used to take a argument to identify a "bundle"
// this bundle support mechanism is obsolete; to enable code based on earlier versions to compile you must 
// 1) change any call to TBApiInit to remove the passed argument 
// 2) remove any calls to API that reference bundles eg TBApiGetBundle 
// 3) remove any reference to "bundle.h" 


// ** MIGRATION NOTE ** in UPDD versions prior to 4.1 static linking of the API libraries 
// was recommended wherever practical. Due to the number of additional dependencies dynamic 
// linkage is now recommended. Both static and dynamic libraries are supplied, but static libraries
// are now obsolescent 
// 


// ** USAGE NOTE **
// The UPDD API needs to be able to identify the UPDD settings file in use (tbupdd.ini) 
// TBApiInit will search the following directories 
// 1) the directory that contains the primary module for the process 
// 2) the current working directory 
// so you should either place your executable module in the UPDD install folder OR 
// set the working directory to the UPDD install folder prior to calling TBApiInit

#undef TBApiInit  
#ifdef TBAPIDLLPFX 
#define TBApiInit  DLL_TBApiInit
#endif

void TBAPI TBApiInit(const TBCHAR* aSettingsPath);
// Initialises the API, and establishes a connection to the device driver
// must be called before any other API functions 
// pass a path to folder containing settings file (tbupdd.ini)
// NULL to use the current working directory 
// or use TBApiDefaultSettingsPath() 
// example TBApiInit(TBApiDefaultSettingsPath())

#undef TBApiDefaultSettingsPath  
#ifdef TBAPIDLLPFX 
#define TBApiDefaultSettingsPath  DLL_TBApiDefaultSettingsPath
#endif
void TBAPI TBApiDefaultSettingsPath(TBCHAR* aSettingsPath, unsigned int aBufferSize); 
// the "ususal" path for updd settings 
// this is correct in most cases, but do not rely on this function if working with a scenario where updd is not installed to a 
// 

#undef TBApiOpen  
#ifdef TBAPIDLLPFX 
#define TBApiOpen  DLL_TBApiOpen
#endif 

BOOL TBAPI TBApiOpen();
// Establishes a connection to the device driver
// returns = fail, 1 = OK
// most API functions require an open connection

#undef TBApiClose 
#ifdef TBAPIDLLPFX 
#define TBApiClose DLL_TBApiClose
#endif 

void TBAPI TBApiClose();
// Closes the connection to the device driver

#undef TBApiIsApiActive 
#ifdef TBAPIDLLPFX 
#define TBApiIsApiActive DLL_TBApiIsApiActive
#endif 

BOOL TBAPI TBApiIsApiActive();
// Returns a boolean indication of whether a valid driver interface exists
// ie has TBApiOpen been sucessfully called. 

#undef TBApiTerminate 
#ifdef TBAPIDLLPFX 
#define TBApiTerminate DLL_TBApiTerminate
#endif 

void TBAPI TBApiTerminate();
// Performs program termination housekeeping 
// do not call other API functions after this

#undef TBApiGetCommsErrors
#ifdef TBAPIDLLPFX
#define TBApiGetCommsErrors DLL_TBApiGetCommsErrors
#endif

BOOL TBAPI TBApiGetCommsErrors(HTBDEVICE aDeviceHandle, DWORD* errors);
// returns the number of comms errors reported by the specified device's interface
// returns -- 0 = fail, 1 = OK

#undef TBApiGetOverflowErrors
#ifdef TBAPIDLLPFX
#define TBApiGetOverflowErrors DLL_TBApiGetOverflowErrors
#endif

BOOL TBAPI TBApiGetOverflowErrors(HTBDEVICE aDeviceHandle, DWORD* errors);
// returns the number of buffer overflows reported by the specified device
// a buffer overflow occurs when incoming data is not processed fast 
// and the allocated buffers become full the driver reallocates 
// these buffers a number of times before allowing an overflow to occur
// returns -- 0 = fail, 1 = OK

#undef TBApiGetSyncErrors
#ifdef TBAPIDLLPFX
#define TBApiGetSyncErrors DLL_TBApiGetSyncErrors
#endif

BOOL TBAPI TBApiGetSyncErrors(HTBDEVICE aDeviceHandle, DWORD* errors);
// returns the number of synchronisation errors reported by the specified device
// a synchronisation errors occurs when the format of the incoming data 
// is not recognised. Comms errors and overflows will usually 
// cause sync errors. Each loss of synchronisation can potentially 
// record several sync errors as the driver attempts to 
// recognise the subsequent data
// returns -- 0 = fail, 1 = OK

#undef TBApiResetErrorCounts
#ifdef TBAPIDLLPFX
#define TBApiResetErrorCounts DLL_TBApiResetErrorCounts
#endif

BOOL TBAPI TBApiResetErrorCounts();
// resets the above error counts (comm, overflow, sync) to zero for all devices
// returns -- 0 = fail, 1 = OK

#undef TBApiGetPagedAllocation
#ifdef TBAPIDLLPFX
#define TBApiGetPagedAllocation DLL_TBApiGetPagedAllocation
#endif

BOOL TBAPI TBApiGetPagedAllocation(DWORD* alloc);
#undef TBApiGetNonPagedAllocation
#ifdef TBAPIDLLPFX
#define TBApiGetNonPagedAllocation DLL_TBApiGetNonPagedAllocation
#endif

BOOL TBAPI TBApiGetNonPagedAllocation(DWORD* alloc);
#undef TBApiGetPagedHWM
#ifdef TBAPIDLLPFX
#define TBApiGetPagedHWM DLL_TBApiGetPagedHWM
#endif

BOOL TBAPI TBApiGetPagedHWM(DWORD* alloc);
#undef TBApiGetNonPagedHWM
#ifdef TBAPIDLLPFX
#define TBApiGetNonPagedHWM DLL_TBApiGetNonPagedHWM
#endif

BOOL TBAPI TBApiGetNonPagedHWM(DWORD* alloc);
// The above 4 API's report the driver's memory usage. 
// However the internal memory management has changed, so the 
// information returned is inaccurate.
// These API's will be replaced in a later release

#undef TBApiGetDriverVersion
#ifdef TBAPIDLLPFX
#define TBApiGetDriverVersion DLL_TBApiGetDriverVersion
#endif

BOOL TBAPI TBApiGetDriverVersion(TBCHAR* aVersion);
// returns a pointer to a string containing the driver version number
// returns -- 0 = fail, 1 = OK

#undef TBApiGetDriverBuild
#ifdef TBAPIDLLPFX
#define TBApiGetDriverBuild DLL_TBApiGetDriverBuild
#endif

BOOL  TBAPI TBApiGetDriverBuild(TBCHAR* aBuild);

#undef TBApiGetNakMessage
#ifdef TBAPIDLLPFX
#define TBApiGetNakMessage DLL_TBApiGetNakMessage
#endif

BOOL TBAPI TBApiGetNakMessage(HTBDEVICE aDeviceHandle, TBCHAR* aMsg, int aMaxLength);
// If the specified device handle executed a macro   
// and the attached controller returned a NAK 
// this function returns a string containing 
// the associated NAK text otherwise returns an empty string
// returns -- 0 = fail, 1 = OK

#undef TBApiGetEventSelectorState
#ifdef TBAPIDLLPFX
#define TBApiGetEventSelectorState DLL_TBApiGetEventSelectorState
#endif

BOOL TBAPI TBApiGetEventSelectorState(DWORD* bState);
// returns (in bState) the current value of the event selector
// 0 = Primary 1 = Alternate
// returns -- 0 = fail, 1 = OK

#undef TBApiSetEventSelectorState
#ifdef TBAPIDLLPFX
#define TBApiSetEventSelectorState DLL_TBApiSetEventSelectorState
#endif

BOOL TBAPI TBApiSetEventSelectorState(DWORD bState);
// Sets the state of the event selector 
// 0 = Primary 1 = Alternate
// returns -- 0 = fail, 1 = OK

#undef TBApiReinit
#ifdef TBAPIDLLPFX
#define TBApiReinit DLL_TBApiReinit
#endif

BOOL TBAPI TBApiReinit(HTBDEVICE aDeviceHandle);
// Requests the specified device handle to re-execute the driver load and controller load macros  
// NB if the macro fails this function will still return OK 
// use TBApiGetMacroStatus to determine whether a macro suceeded
// returns -- 0 = fail, 1 = OK

#undef TBApiGetMacroStatus
#ifdef TBAPIDLLPFX
#define TBApiGetMacroStatus DLL_TBApiGetMacroStatus
#endif

BOOL TBAPI TBApiGetMacroStatus(HTBDEVICE aDeviceHandle, DWORD* aState);
// returns (in aState) the current status of the macro processor for the specified device
//enum _MacroState
//{
// eMacroNotStarted, 
// eStarted, 
// eTimedOut, 
// eFailed, 
// eSyntax, 
// eNotSupported, 
// eNoMacro,   
// eComplete 
//};
// returns -- 0 = fail, 1 = OK

#undef TBApiDriverEnable
#ifdef TBAPIDLLPFX
#define TBApiDriverEnable DLL_TBApiDriverEnable
#endif

BOOL TBAPI TBApiDriverEnable( BOOL aState);
// enables or disables the driver. 
// if disabled the driver discards all packets read
// data is not passed to the mouse port or any registered callback
// returns -- 0 = fail, 1 = OK


#undef TBApiApply
#ifdef TBAPIDLLPFX
#define TBApiApply DLL_TBApiApply
#endif

BOOL TBAPI TBApiApply();
#undef TBApiApplyNoReload
#ifdef TBAPIDLLPFX
#define TBApiApplyNoReload DLL_TBApiApplyNoReload
#endif

BOOL TBAPI TBApiApplyNoReload();
// Some API's change registry settings, but do not write 
// them back to the registry until the user calls TBApiApply
// Note 1) if a real change (as opposed to an operation that retains the current registry setting) 
//         is detected, the driver is re-initialised. All connections are re-established
// Note 2) Prior to calling TBApiApply, api calls that read registry values 
//         will return any changed data that exists NOT the registry value
// returns -- 0 = fail, 1 = OK
// The NoReload variation does not reinitialise the driver 

#undef TBApiReloadNoApply 
#ifdef TBAPIDLLPFX 
#define TBApiReloadNoApply DLL_TBApiReloadNoApply
#endif 

BOOL TBAPI TBApiReloadNoApply(/**/);  
// This variation reloads the driver, but does not apply pending changes.
// Mainly used to indicate to apps that a non-registry change (such as 
// keypad macro file definitions) have changed

/*  - these apis are now obsolete
#undef TBApiGetADX 
#ifdef TBAPIDLLPFX 
#define TBApiGetADX DLL_TBApiGetADX
#endif 

BOOL TBAPI TBApiGetADX(HTBDEVICE aDeviceHandle, DWORD* aData);
// returns( in aData ) the 'X' value of the most recent AD sample
// this call is hardware specific

#undef TBApiGetADY 
#ifdef TBAPIDLLPFX 
#define TBApiGetADY DLL_TBApiGetADY
#endif 

BOOL TBAPI TBApiGetADY(HTBDEVICE aDeviceHandle, DWORD* aData);
// returns( in aData ) the 'X' value of the most recent AD sample
// this call is hardware specific
*/

#undef TBApiAddToolbar 
#ifdef TBAPIDLLPFX 
#define TBApiAddToolbar DLL_TBApiAddToolbar
#endif 

BOOL TBAPI TBApiAddToolbar(HTBDEVICE aDevice, LPCTSTR name);
// Adds the toolbar "name" if it doesn't already exist

#undef TBApiRemoveToolbar 
#ifdef TBAPIDLLPFX 
#define TBApiRemoveToolbar DLL_TBApiRemoveToolbar
#endif 

BOOL TBAPI TBApiRemoveToolbar(HTBDEVICE aDevice,LPCTSTR name);
// Removes the toolbar "name" if it exists

#undef TBApiCalibrateToolbar 
#ifdef TBAPIDLLPFX 
#define TBApiCalibrateToolbar DLL_TBApiCalibrateToolbar
#endif 

BOOL TBAPI TBApiCalibrateToolbar(HTBDEVICE aDevice,LPCTSTR name);
// Calibrate the toolbar "name" if it exists

 
// --------------------------------------------------------------- //
//         a number of functions require a device id               // 
//   the following family of functions provide valid device id's   // 
// --------------------------------------------------------------- // 
// 
 
#undef TBApiGetRelativeDevice
#ifdef TBAPIDLLPFX
#define TBApiGetRelativeDevice DLL_TBApiGetRelativeDevice
#endif

HTBDEVICE TBAPI   TBApiGetRelativeDevice(int o);
// this api simply gets the deice by it's order in the internal device list 
// typically used to get the only device in a single device system eg 
//
//  HTBDEVICE device = TBApiGetRelativeDevice(0);
//
//  or to enumerate all devices eg
//
//  HTBDEVICE device = TBApiGetRelativeDevice(0);
//  for(int i=0; device != TB_INVALID_HANDLE_VALUE;) 
//  {
//      DoSomethingWithDevice(device);
//      device = TBApiGetRelativeDevice(++i);
//  }
//
//  a return value of TB_INVALID_HANDLE_VALUE means that the requested device does not exist

#undef TBApiGetNamedToolbar 
#ifdef TBAPIDLLPFX 
#define TBApiGetNamedToolbar DLL_TBApiGetNamedToolbar
#endif 
  
int TBAPI TBApiGetNamedToolbar(HTBDEVICE aDevice, LPCTSTR name);

#undef TBApiGetRelativeDeviceNoHidden
#ifdef TBAPIDLLPFX
#define TBApiGetRelativeDeviceNoHidden DLL_TBApiGetRelativeDeviceNoHidden
#endif

HTBDEVICE TBAPI   TBApiGetRelativeDeviceNoHidden(int o);
// this api simply gets the deice by it's order in the internal device list
// excluding devices that are unplugged (hidden) as well as following
// the semantics of TBApiGetRelativeDevice() 
// see TBApiGetRelativeDevice


#undef TBApiGetRelativeDeviceIncHidden
#ifdef TBAPIDLLPFX
#define TBApiGetRelativeDeviceIncHidden DLL_TBApiGetRelativeDeviceIncHidden
#endif

HTBDEVICE TBAPI   TBApiGetRelativeDeviceIncHidden(int o);


#undef TBApiGetRelativeDeviceFromHandle
#ifdef TBAPIDLLPFX
#define TBApiGetRelativeDeviceFromHandle DLL_TBApiGetRelativeDeviceFromHandle
#endif

int TBAPI TBApiGetRelativeDeviceFromHandle( HTBDEVICE aDeviceHandle); 
// this api performs the opposite role to TBApiGetRelativeDevice
// Given a Device handle the (zero based) position in the list is returned 
// a return value of -1 means that the requested device does not exist

#undef TBApiGetNamedDevice
#ifdef TBAPIDLLPFX
#define TBApiGetNamedDevice DLL_TBApiGetNamedDevice
#endif

HTBDEVICE TBAPI   TBApiGetNamedDevice( const TBCHAR* aName);
// this api gets the device handle using the name assigned to it 
// eg 
//
// HTBDEVICE device = TBApiGetNamedDevice(_T("Whiteboard 1"));
// 
//  a return value of TB_INVALID_HANDLE_VALUE means that the requested device does not exist

#undef TBApiGetDeviceFromSegment
#ifdef TBAPIDLLPFX
#define TBApiGetDeviceFromSegment DLL_TBApiGetDeviceFromSegment
#endif

HTBDEVICE TBAPI   TBApiGetDeviceFromSegment( const TBCHAR* aSegment);
// this api gets the device handle using the name of it's logical screen segment
// eg 
//
// HTBDEVICE device = TBApiGetDeviceFromSegment(_T("Left Half"));
// 
//  a return value of TB_INVALID_HANDLE_VALUE means that the requested device does not exist
// 

#undef TBApiSendNetworkData
#ifdef TBAPIDLLPFX
#define TBApiSendNetworkData DLL_TBApiSendNetworkData
#endif

BOOL TBAPI TBApiSendNetworkData(void* data, DWORD length, DWORD aDelay);

#undef TBApiForwardNetworkData
#ifdef TBAPIDLLPFX
#define TBApiForwardNetworkData DLL_TBApiForwardNetworkData
#endif

BOOL TBAPI TBApiForwardNetworkData(void* data, DWORD length, DWORD aDelay);

#undef TBApiSendData
#ifdef TBAPIDLLPFX
#define TBApiSendData DLL_TBApiSendData
#endif

BOOL TBAPI TBApiSendData(HTBDEVICE aDeviceHandle, void* data, DWORD length, DWORD aDelay);

// Sends data to the controller associated with the specified device
//
// The following example sends "hello world" to the first controller on the 
// system with a 1 millisecond delay between characters
//
//  HTBDEVICE device = TBApiGetRelativeDevice(0);
//  char msg[]="hello world";
//  TBApiSendData(device, msg, _tcslen(msg), 1);

#undef TBApiGetRotate
#ifdef TBAPIDLLPFX
#define TBApiGetRotate DLL_TBApiGetRotate
#endif

BOOL TBAPI TBApiGetRotate(HTBDEVICE aDeviceHandle, DWORD* aRotate);
// returns (in aRotate) the rotation factor associated with the device
// returns -- 0 = fail, 1 = OK

#undef TBApiSetRotate
#ifdef TBAPIDLLPFX
#define TBApiSetRotate DLL_TBApiSetRotate
#endif

BOOL TBAPI TBApiSetRotate(HTBDEVICE aDeviceHandle, DWORD aRotate);
// set the rotation factor
// returns -- 0 = fail, 1 = OK

#undef TBApiAbortDriver
#ifdef TBAPIDLLPFX
#define TBApiAbortDriver DLL_TBApiAbortDriver
#endif

void TBAPI TBApiAbortDriver();  
// causes the driver to close all connections and release 
// all resources, used during un-install process to free resources
// prior to deletion

#undef TBApiMousePortInterfaceEnable
#ifdef TBAPIDLLPFX
#define TBApiMousePortInterfaceEnable DLL_TBApiMousePortInterfaceEnable
#endif

BOOL TBAPI TBApiMousePortInterfaceEnable(int aState); 
//changed to int instead of BOOL for 64 bit compat 
// Enable / disables the mouse port interface
// if the mouse port interface is disabled, the driver functions 
// normally, except that the mouse pointer is not moved and 
// mouse button clicks are not emulated. Data can be read via the api
// returns -- 0 = fail, 1 = OK

#undef TBApiMousePortInterfaceEnableEx
#ifdef TBAPIDLLPFX
#define TBApiMousePortInterfaceEnableEx DLL_TBApiMousePortInterfaceEnableEx
#endif

BOOL TBAPI TBApiMousePortInterfaceEnableEx(HTBDEVICE aDevice, BOOL aState);
// Enable / disables the mouse port interface for a device
// if the mouse port interface is disabled, the driver functions 
// normally, except that the mouse pointer is not moved and 
// mouse button clicks are not emulated. Data can be read via the api
// returns -- 0 = fail, 1 = OK

#undef TBApiIgnoreToolbars
#ifdef TBAPIDLLPFX
#define TBApiIgnoreToolbars DLL_TBApiIgnoreToolbars
#endif

BOOL TBAPI TBApiIgnoreToolbars(BOOL aState);
// Enable / disables toolbar processing 
// if set to TRUE (ignore) then pointer actions in the 
// toolbar areas are processed as normal touches  
// used during calibration to allow calibration of toolbar areas 
// returns -- 0 = fail, 1 = OK

//BOOL TBApiSetCalibrationStyle(HTBDEVICE aDeviceHandle,TBCHAR* aStyleName,TBCHAR* aStyle);
// Sets the calibration style for the specified device
// aStyleName specifies the name aStyle should be a normally be empty string, 
// A style can be added or changed by specifying the style format aStyle
//
// eg 1, selecting the existing calibration style "Projected"
// TBApiSetCalibrationStyle(device,_T("Projected"),_T(""));
// 
// eg 2, creating a new calibration style "New Style"
// TBApiSetCalibrationStyle(device,_T("New Style"),_T("New Style,2,12,10,0,0"));
// This creates a style with 2 points, 12  1244844n, 10 second timeout, not transparent, and no rotation
// returns -- 0 = fail, 1 = OK

// obsolete, use TBApiGetSettingSZ 
//BOOL TBApiGetCalibrationStyle(HTBDEVICE aDeviceHandle,TBCHAR* aStyle, int lBuffer);
// Gets the name of the current calibration style for the specified device
// into a user supplied buffer
// returns -- 0 = fail, 1 = OK

//BOOL TBAPI TBApiGetCalibrationStyleNames(HTBDEVICE aDeviceHandle,TBCHAR* aStyles, int lBuffer);
// Gets the name of all calibration styles for the specified device
// into a user supplied buffer. The list is separated by semi colons. 
// returns -- 0 = fail, 1 = OK

#undef TBApiSetScaleDimensions
#ifdef TBAPIDLLPFX
#define TBApiSetScaleDimensions DLL_TBApiSetScaleDimensions
#endif

BOOL TBAPI TBApiSetScaleDimensions(long* handle, long left, long top, long right, long bottom);
// Allows a program to specify scaling factors for subsequent calls to TBApiScaleCoordinates
// Typically used to map pointer co-ordinates to a window size
// Should be called if the window size or position changes 
// The handle should be -1 on the first call. On subsequent calls for the same target the 
// value returned from the first call should be used
// See example for TBApiScaleCoordinates
// returns -- 0 = fail, 1 = OK


#undef TBApiConvertHexString
#ifdef TBAPIDLLPFX
#define TBApiConvertHexString DLL_TBApiConvertHexString
#endif
BOOL TBAPI TBApiConvertHexString(TBCHAR *s, int iLength);


#undef TBApiScaleCoordinatesOld
#ifdef TBAPIDLLPFX
#define TBApiScaleCoordinatesOld DLL_TBApiScaleCoordinatesOld
#endif

BOOL TBAPI TBApiScaleCoordinatesOld(long* handle, _PointerData* data, unsigned short* x,unsigned short* y);
// given a _PointerData struct with co-ordinate data, modifies the co-ordinates 
// to fit in the rectangle specified in TBApiSetScaleDimensions
// 
// Example 
// 
// At window creation 
//
// long scaleHandle = -1;
// TBApiSetScaleDimensions(&scaleHandle,l,t,r,b); // where l,t,r,b represent the window initial co-ordinates
// 
// Whenever window is moved or resized
//
// TBApiSetScaleDimensions(&scaleHandle,l,t,r,b); // where l,t,r,b represent the new window co-ordinates
//
// In data callback 
//  
// short x,y;
// TBApiScaleCoordinates(scaleHandle,data,&x,&y)
// x,y now hold the co-ordinate values from data mapped to the target area
// returns -- 0 = fail, 1 = OK

#undef TBApiScaleCoordinates
#ifdef TBAPIDLLPFX
#define TBApiScaleCoordinates DLL_TBApiScaleCoordinates
#endif

BOOL TBAPI TBApiScaleCoordinates(long* handle, _PointerData* data, long* x,long* y);


#undef TBApiRegisterDataCallback
#ifdef TBAPIDLLPFX
#define TBApiRegisterDataCallback DLL_TBApiRegisterDataCallback
#endif

BOOL TBAPI TBApiRegisterDataCallback(HTBDEVICE aDeviceHandle, unsigned long aContext, unsigned long aTypes, TB_DATA_CALL aFunc);
// Informs the API that a function is to be used a callback function for 
// the specified type(s) of data 
// The context value is passed unchanged to the callback function for identification purposes 
// All functions registered MUST be unregistered with TBApiUnregisterDataCallback
// before the program terminates
//
// In the following example CBFunc is called whenever pointer co-ordinates are processed
// by relative device 1 until TBApiUnregisterDataCallback is called
//
// **USAGE NOTE**
// the callback function is executed in the context of a dedicated thread 
// therefore only thread safe (reentrant) functions should be called from the callback function
// many windowing api functions are non-reentrant
// if you need to call non-reentrant functions you need to provide synchronisation management 
// a common way to achieve this is to post a message to the primary process thread and perform 
// all non-reentrant operations from the primary thread
//
// example 1; register callback for the first device found
// 
// HTBDEVICE hd = TBApiGetRelativeDevice(0);
//
// TBApiRegisterDataCallback(hd,0,_ReadDataTypeXY,CBFunc); 
//
// .....
//
// void TBAPI CBFunc(unsigned long context, _PointerData* data)
// {
//      printf("device %d generated x=%d y=%d\n",(int)data->device,(int)data->xy->rawx,(int)data->xy->rawy);
// }
//
// To get data for all devices 0
// 
// example 2; register callback for all devices
// 
// TBApiRegisterDataCallback(0,_ReadDataTypeXY,CBFunc); 
// 
// returns -- 0 = fail, 1 = OK

#undef TBApiUnregisterDataCallback
#ifdef TBAPIDLLPFX
#define TBApiUnregisterDataCallback DLL_TBApiUnregisterDataCallback
#endif

BOOL TBAPI TBApiUnregisterDataCallback(TB_DATA_CALL aFunc);
// Removes the specified function from the list of registered callbacks. 
// 
// eg to unregister the callback specified in the above exaple 
// 
// TBApiRegisterDataCallback(CBFunc); 
//
// returns -- 0 = fail, 1 = OK

#undef TBApiUnregisterDataCallbackContext
#ifdef TBAPIDLLPFX
#define TBApiUnregisterDataCallbackContext DLL_TBApiUnregisterDataCallbackContext
#endif

BOOL TBAPI TBApiUnregisterDataCallbackContext(TB_DATA_CALL aFunc, unsigned long aContext);
// Removes the specified function from the list of registered callbacks. 
// for the specfied context only. Callbacks for the specfied function 
// but with a different context remain active
// 
// eg to unregister the callback specified in the above example 
// 
// TBApiUnregisterDataCallbackContext(CBFunc,0); 
//
// returns -- 0 = fail, 1 = OK

//BOOL TBAPI TBApiGetToolbarNames(HTBDEVICE aDeviceHandle,TBCHAR* aToolbarNames, int lBuffer) ;
// Gets the name of all toolbars for the specified device
// into a user supplied buffer. The list is separated by semi colons. 
// returns -- 0 = fail, 1 = OK

//BOOL TBAPI TBApiGetToolbars(HTBDEVICE aDeviceHandle,TBCHAR* aToolbars, int lBuffer) ;
// Gets the toolbar definition string for the specified device
// into a user supplied buffer. 
// returns -- 0 = fail, 1 = OK

// a set of functions to set / retrieve registry settings
// call  TBApiApply() to commit the changes 
#undef TBApiGetSettingSZ 
#ifdef TBAPIDLLPFX 
#define TBApiGetSettingSZ DLL_TBApiGetSettingSZ
#endif 

BOOL TBAPI TBApiGetSettingSZ(HTBDEVICE aHandle,const TBCHAR* aName, TBCHAR* aSZ, int lBuff);
#undef TBApiGetSettingDWORD 
#ifdef TBAPIDLLPFX 
#define TBApiGetSettingDWORD DLL_TBApiGetSettingDWORD
#endif 

BOOL TBAPI TBApiGetSettingDWORD(HTBDEVICE aHandle,const TBCHAR* aName, unsigned long* val);
#undef TBApiSetSettingSZ 
#ifdef TBAPIDLLPFX 
#define TBApiSetSettingSZ DLL_TBApiSetSettingSZ
#endif 

BOOL TBAPI TBApiSetSettingSZ(HTBDEVICE aHandle,const TBCHAR* aName, const TBCHAR* aSZ);
#undef TBApiSetSettingDWORD 
#ifdef TBAPIDLLPFX 
#define TBApiSetSettingDWORD DLL_TBApiSetSettingDWORD
#endif 

BOOL TBAPI TBApiSetSettingDWORD(HTBDEVICE aHandle,const TBCHAR* aName, unsigned long val);

#undef TBApiSetGlobalSettingDWORD 
#ifdef TBAPIDLLPFX 
#define TBApiSetGlobalSettingDWORD DLL_TBApiSetGlobalSettingDWORD
#endif 

BOOL  TBAPI TBApiSetGlobalSettingDWORD(const TBCHAR* aName, unsigned long val);

#undef TBApiSetGlobalSettingSZ
#ifdef TBAPIDLLPFX 
#define TBApiSetGlobalSettingSZ DLL_TBApiSetGlobalSettingSZ
#endif 

BOOL  TBAPI TBApiSetGlobalSettingSZ(const TBCHAR* aName,const TBCHAR* aSZ);

#undef TBApiGetGlobalSettingSZ
#ifdef TBAPIDLLPFX 
#define TBApiGetGlobalSettingSZ DLL_TBApiGetGlobalSettingSZ
#endif 

BOOL TBAPI TBApiGetGlobalSettingSZ(const TBCHAR* aName,  TBCHAR* aSZ, int lBuff);

#undef TBApiGetGlobalSettingDWORD 
#ifdef TBAPIDLLPFX 
#define TBApiGetGlobalSettingDWORD DLL_TBApiGetGlobalSettingDWORD
#endif 

BOOL  TBAPI TBApiGetGlobalSettingDWORD(const TBCHAR* aName, unsigned long* val);

// extended versions of the above that allow a named subtree and node to be accessed
// eg for calibration styles - use aSubTree = "" to emulate the "non-extended" versions
// some of these api's do special processing also, this list may be extended in future releases 
// 1) TBApiSetSettingSZEx if aName=="Calibration Style" && aSubtree=="" the indicated style is activated 

// the following example shows the settings that make up a typical 
// subtree
//
//  HKLM\System\CurrentControlSet\Services\TBUPDD\ ->
//      ...\{....}\Parameters\1\Number Of Calibration Styles - item count  
//      ...\{....}\Parameters\1\Calibration Style - active item name
//      ...\{....}\Parameters\1\Calibration Styles\0\Calibration Style - item name
//      ...\{....}\Parameters\1\Calibration Styles\0\... - other item data


#undef TBApiGetSettingSZEx 
#ifdef TBAPIDLLPFX 
#define TBApiGetSettingSZEx DLL_TBApiGetSettingSZEx
#endif 

BOOL TBAPI TBApiGetSettingSZEx(HTBDEVICE aHandle,const TBCHAR* aSubtree,const TBCHAR* aName, TBCHAR* aSZ, int lBuff);
#undef TBApiGetSettingDWORDEx 
#ifdef TBAPIDLLPFX 
#define TBApiGetSettingDWORDEx DLL_TBApiGetSettingDWORDEx
#endif 

BOOL TBAPI TBApiGetSettingDWORDEx(HTBDEVICE aHandle,const TBCHAR* aSubtree,const TBCHAR* aName, unsigned long* val);
#undef TBApiSetSettingSZEx 
#ifdef TBAPIDLLPFX 
#define TBApiSetSettingSZEx DLL_TBApiSetSettingSZEx
#endif 

BOOL TBAPI TBApiSetSettingSZEx(HTBDEVICE aHandle,const TBCHAR* aSubtree,const TBCHAR* aName, const TBCHAR* aSZ);
#undef TBApiSetSettingDWORDEx 
#ifdef TBAPIDLLPFX 
#define TBApiSetSettingDWORDEx DLL_TBApiSetSettingDWORDEx
#endif 

BOOL TBAPI TBApiSetSettingDWORDEx(HTBDEVICE aHandle,const TBCHAR* aSubtree,const TBCHAR* aName, unsigned long val);

// get the number of the last button pressed in a toolbar, and a relative 
// time (tick) at which the touch occcured
//
// Eg to get the "current" button in device 1, toolbar "Toolbar" 
// in the group of buttons 2 - 7 
//
// unsigned short button;
// unsigned long tick;
// TBApiGetRecentToolbarButton(1,_T("Toolbar"),2,7,&button,&tick);
//
// Note 1: You should always check the tick value, a value of zero means NO press has occured
// Note 2: Buttons numbers are zero based
#undef TBApiGetRecentToolbarButton 
#ifdef TBAPIDLLPFX 
#define TBApiGetRecentToolbarButton DLL_TBApiGetRecentToolbarButton
#endif 

BOOL TBAPI TBApiGetRecentToolbarButton(HTBDEVICE aDeviceHandle,const TBCHAR* aToolbarName, unsigned short aFirstButton, unsigned short aLastButton, unsigned short* aButton, unsigned long* aTick);

// obsolete, use TBApiSetMouseScaling instead 
//// set the calibration scheme to a restricted screen area
//// the current scheme MUST be 2 point 0
//BOOL TBApiSetCustomLogicalDesktop(HTBDEVICE aDeviceHandle, long left, long top, long right, long bottom);

// instruct the driver to direct all mouse activity for the specified 
// device to the specified desktop rectangle, scaling as appropriate 
#undef TBApiDeviceSetMouseScaling 
#ifdef TBAPIDLLPFX 
#define TBApiDeviceSetMouseScaling DLL_TBApiDeviceSetMouseScaling
#endif 

BOOL TBAPI TBApiDeviceSetMouseScaling(HTBDEVICE aDeviceHandle, long left, long top, long right, long bottom);

// instruct the driver to direct all mouse activity for the specified 
// device to the standard location, ie negate the effect of 
// any previous TBApiDeviceSetMouseScaling call  
#undef TBApiDeviceStopMouseScaling 
#ifdef TBAPIDLLPFX 
#define TBApiDeviceStopMouseScaling DLL_TBApiDeviceStopMouseScaling
#endif 

BOOL TBAPI TBApiDeviceStopMouseScaling(HTBDEVICE aDeviceHandle);

// Determines if the device exists
#undef TBApiValidateDevice 
#ifdef TBAPIDLLPFX 
#define TBApiValidateDevice DLL_TBApiValidateDevice
#endif 

BOOL TBAPI TBApiValidateDevice(HTBDEVICE aDeviceHandle);


/*
// add or replace a new controller to/in the device list

// aControllerKey        :  the numeric part of the controller key (eg for TS001 = 1) 
// aDevice               :  the device handle  to add or replace - use 0 to assign the next available 
// aLogicalDeviceSegment :  the desktop segment controlled by this controller, pass NULL for "Whole" 
// aDeviceName           :  a name to identify the controller, pass NULL to assign an auto generated id
// id and increment the # of controllers
  BOOL TBAPI TBApiAddDevice(GUID aController, HTBVOID aDeviceHandle, const TBCHAR* aLogicalDeviceSegment, const TBCHAR* aDeviceName);
*/


// add or replace a new controller to/in the device list

// aControllerKey        :  the numeric part of the controller key (eg for TS001 = 1) 
// aDeviceId             :  the device id  to add or replace - use 0 to assign the next available 
// aLogicalDeviceSegment :  the desktop segment controlled by this controller, pass NULL for "Whole" 
// aDeviceName           :  a name to identify the controller, pass NULL to assign an auto generated id
// id and increment the # of controllers
// aDisplayUnbound       :  flag if the device should be shown if it has never been bound
#undef TBApiAddDevice 
#ifdef TBAPIDLLPFX 
#define TBApiAddDevice DLL_TBApiAddDevice
#endif 

BOOL TBAPI TBApiAddDevice(int aControllerKey, HTBDEVICE aDevice, const TBCHAR* aLogicalDeviceSegment, const TBCHAR* aDeviceName, int aDisplayUnbound,const TBCHAR* aPort);

						      
// given a calibration style name, return the style handle 
// returns -1 if not found
#undef TBApiGetCalibrationStyleByName 
#ifdef TBAPIDLLPFX 
#define TBApiGetCalibrationStyleByName DLL_TBApiGetCalibrationStyleByName
#endif 

HTBSTYLE TBAPI TBApiGetCalibrationStyleByName(HTBDEVICE aDeviceHandle, const TBCHAR* aStyleName);
// get the calibration style details for the specified device & style
#undef TBApiGetCalibrationStyle 
#ifdef TBAPIDLLPFX 
#define TBApiGetCalibrationStyle DLL_TBApiGetCalibrationStyle
#endif 

BOOL TBAPI TBApiGetCalibrationStyle(HTBDEVICE aDeviceHandle, HTBSTYLE aHStyle, _CalStyle* aStyle);

// change the settings for an existing calibration style 
// or add a new style - by using aHStyle = TBNEW_STYLE  
// note - the calibration reference points are re-calculated 
// by this function
#undef TBApiSetCalibrationStyle 
#ifdef TBAPIDLLPFX 
#define TBApiSetCalibrationStyle DLL_TBApiSetCalibrationStyle
#endif 

BOOL  TBAPI TBApiSetCalibrationStyle(HTBDEVICE aDeviceHandle, HTBSTYLE aHStyle, _CalStyle* aStyle);
  
// activate the named calibration style for the specified device handle
// if aSupressAutoCal = TRUE and the activated style has no 
// calibration data, ie defaults were not supplied AND no calibration 
// has been executed the API will ensure that when a subsequent call 
// to TBApiApply() is made auto cal will NOT execute 

// if calling this API ouside of a calibration routine, 
// aSupressAutoCal should usually be set to TRUE - this is because when 
// TBApiApply() is called - autocal may be invoked, leading to an unwanted 
// change to the activated style settings
#undef TBApiActivateCalibrationStyle 
#ifdef TBAPIDLLPFX 
#define TBApiActivateCalibrationStyle DLL_TBApiActivateCalibrationStyle
#endif 

BOOL TBAPI TBApiActivateCalibrationStyle(HTBDEVICE aDeviceHandle, const TBCHAR* aStyleName, BOOL aSupressAutoCal);

// delete the definition of the specified calibration style
#undef TBApiRemoveCalibrationStyle 
#ifdef TBAPIDLLPFX 
#define TBApiRemoveCalibrationStyle DLL_TBApiRemoveCalibrationStyle
#endif 

BOOL TBAPI TBApiRemoveCalibrationStyle(HTBDEVICE aDeviceHandle, const TBCHAR* aStyleName);

// retrieve the calibration settings for the specified device in a 
// _CalStyle structure 
#undef TBApiGetCalibrationAsStyle 
#ifdef TBAPIDLLPFX 
#define TBApiGetCalibrationAsStyle DLL_TBApiGetCalibrationAsStyle
#endif 

BOOL TBAPI TBApiGetCalibrationAsStyle(HTBDEVICE aDeviceHandle, _CalStyle* aStyle);
// WinCE does not implement the CRT function lfind, so we implement a version of it 
// it is identical in operation to the standard lfind
// this is used in the standard calibration program
#undef TBApilfind 
#ifdef TBAPIDLLPFX 
#define TBApilfind DLL_TBApilfindvoid
#endif 

#ifndef _AMD64_
void* /*TBAPI*/ TBApilfind( const void *key, 
const void *base, 
unsigned int *num, 
unsigned int width, 
int (__cdecl *compare)(const void *elem1, 
const void *elem2) );
#else
void*  TBApilfind( const void *key, 
const void *base, 
unsigned int *num, 
unsigned int width, 
int (__cdecl *compare)(const void *elem1, 
const void *elem2) );

#endif
// Determine whether the driver's event manager is operating in one hit mode
#undef TBApiGetEventSelectorOneHitMode 
#ifdef TBAPIDLLPFX 
#define TBApiGetEventSelectorOneHitMode DLL_TBApiGetEventSelectorOneHitMode
#endif 

BOOL TBAPI TBApiGetEventSelectorOneHitMode(DWORD* bOneHit);
// Set or unset one hit mode for the driver's event manager
#undef TBApiSetEventSelectorOneHitMode 
#ifdef TBAPIDLLPFX 
#define TBApiSetEventSelectorOneHitMode DLL_TBApiSetEventSelectorOneHitMode
#endif 

BOOL TBAPI TBApiSetEventSelectorOneHitMode(DWORD bOneHit);

// The following 2 functions are now obsolete, and will be removed in a later release 
//BOOL TBApiFlushPointerData();	  
//BOOL TBApiWaitForPointer();

// when using the debug version of the api debug messages can be turned on / off with this api 
// the possible values are 
// 0 - no debug messages 
// 1 - mimimal debug message 
// 2 - maximum debug message NB this will affect performance 

// debug messages are sent to the active debug window 
// not all api have trace information
// the callback related apis have fairly comprehensive trace information
#undef TBApiSetApiTraceLevel 
#ifdef TBAPIDLLPFX 
#define TBApiSetApiTraceLevel DLL_TBApiSetApiTraceLevel
#endif 

void TBAPI TBApiSetApiTraceLevel(int aLevel);

// returns the port i/o address used by a device
#undef TBApiGetDeviceAddress 
#ifdef TBAPIDLLPFX 
#define TBApiGetDeviceAddress DLL_TBApiGetDeviceAddress
#endif 

BOOL TBAPI TBApiGetDeviceAddress(HTBDEVICE aDeviceHandle, DWORD* aAddress);

// returns the irq used by a device
#undef TBApiGetDeviceIrq 
#ifdef TBAPIDLLPFX 
#define TBApiGetDeviceIrq DLL_TBApiGetDeviceIrq
#endif 

BOOL TBAPI TBApiGetDeviceIrq(HTBDEVICE aDeviceHandle, DWORD* aIrq);

// dump the current system configuration
/*#undef TBApiDump 
#ifdef TBAPIDLLPFX 
#define TBApiDump DLL_TBApiDump
#endif 

BOOL  TBAPI TBApiDump();*/

// get a list of com port names on the current machine 
// the updd driver must be active 
// the buffer must be large enough to contain all possible names 
// items are separated by newline characters
#undef TBApiGetComPortNames 
#ifdef TBAPIDLLPFX 
#define TBApiGetComPortNames DLL_TBApiGetComPortNames
#endif 

BOOL TBAPI TBApiGetComPortNames(TBCHAR* aBuff,int aBuffLength);

// this is a help function to enabling splitting a token seperated into individual tokens 
// although it is not directly relevant to the driver api it is useful 
// in the manipulaation of such strings which are used by some parts of the api 
// a callback function is used - see TBCalib source code for examples of the actual use of 
// this function

typedef void (_cdecl *STRING_TOKENS_CALLBACK)(void* aContext, const TBCHAR* token);
#undef TBApiEnumStringTokens 
#ifdef TBAPIDLLPFX 
#define TBApiEnumStringTokens DLL_TBApiEnumStringTokens
#endif 

void TBAPI TBApiEnumStringTokens(STRING_TOKENS_CALLBACK aCb, void* aContext, const TBCHAR* aString, const TBCHAR* aDelimiter);

//// identifies an area of the desktop as covered by a visible keyboard
//// the mouse will be moved in this area - but left button operations 
//// are masked - this allows a keyboard utility to be used without focus 
//// switches taking place  
//#undef TBApiRegisterKeyboard 
//#ifdef TBAPIDLLPFX 
//#define TBApiRegisterKeyboard DLL_TBApiRegisterKeyboard
//#endif 
//
//BOOL TBAPI TBApiRegisterKeyboard(DWORD aKeyboardNumber, long left, long top, long right, long bottom );
//
//// returns true if an on screen masked keyboard is touched 
//#undef TBApiIsTouchingKeyboard 
//#ifdef TBAPIDLLPFX 
//#define TBApiIsTouchingKeyboard DLL_TBApiIsTouchingKeyboard
//#endif 
//
//BOOL TBAPI TBApiIsTouchingKeyboard(); 
//
//#undef TBApiUnregisterKeyboard 
//#ifdef TBAPIDLLPFX 
//#define TBApiUnregisterKeyboard DLL_TBApiUnregisterKeyboard
//#endif 
//
//BOOL TBAPI TBApiUnregisterKeyboard(DWORD aKeyboardNumber);

#undef TBApiSendMacro 
#ifdef TBAPIDLLPFX 
#define TBApiSendMacro DLL_TBApiSendMacro
#endif 

BOOL TBAPI TBApiSendMacro(HTBDEVICE aDeviceHandle, const TBCHAR* aMacro);
BOOL TBAPI  TBApiSendMacroSynchronous(HTBDEVICE aDeviceHandle, const TBCHAR* aMacro, void* aUSBRetBuffer, DWORD aUSBRetBufferSize);
// Sends data to the controller associated with the specified device
// using the UPDD macro language
// aMacro is a null terminated string with a maximum length of 2046 bytes
//
// The following example sends "hello world" to the first controller on the 
// system with a 1 second gap between words
//
//  HTBDEVICE device = TBApiGetRelativeDevice(0);
//  char macro[]="hello [WAIT 1000]world";
//  TBApiSendMacro(device, macro);

// Callback to receive ad-hoc settings, see below
typedef void (_stdcall *ADHOC_VALUES_CALLBACK)(void* aContext, const TBCHAR* key, const TBCHAR* aValue, DWORD dwValue, BOOL bIsString);

// This routine identifies ad hoc settings (if any) for the specified 
// device and returns the key together with a string or doubleword
//value
//  
#undef TBApiEnumAdhocValues  
#ifdef TBAPIDLLPFX 
#define TBApiEnumAdhocValues DLL_TBApiEnumAdhocValues
#endif 

void TBAPI TBApiEnumAdhocValues(HTBDEVICE aDeviceHandle, ADHOC_VALUES_CALLBACK aCb, void* aContext);

// set raw data mode for a specified device
// in raw data mode the pointer interface is suspended
// if a client has registered a _ReadDataTypeData callback 
// the data will be delivered to the callback function

#undef TBApiRawDataMode 
#ifdef TBAPIDLLPFX 
#define TBApiRawDataMode DLL_TBApiRawDataMode
#endif 

BOOL TBAPI TBApiRawDataMode(HTBDEVICE aDeviceHandle, BOOL aRawMode);

// determines the block size for raw data mode
// data packets are only delivered when aBlockSize
// bytes have been received
// aBlockSize must be a value between 1 and the maximum packet
// size of the controller
// the default is 1 

#undef TBApiRawDataModeBlockSize 
#ifdef TBAPIDLLPFX 
#define TBApiRawDataModeBlockSize DLL_TBApiRawDataModeBlockSize
#endif 

BOOL TBAPI TBApiRawDataModeBlockSize(HTBDEVICE aDeviceHandle, DWORD aBlockSize);

#undef TBApiSetVirtualDesktopMetrics 
#ifdef TBAPIDLLPFX 
#define TBApiSetVirtualDesktopMetrics DLL_TBApiSetVirtualDesktopMetrics
#endif 

BOOL TBAPI TBApiSetVirtualDesktopMetrics(unsigned long left, unsigned long top, unsigned long width, unsigned long height);

#undef TBApiSetScreenSaverMode 
#ifdef TBAPIDLLPFX 
#define TBApiSetScreenSaverMode DLL_TBApiSetScreenSaverMode
#endif 

BOOL TBAPI TBApiSetScreenSaverMode(BOOL aMode); 

// Get the current state of controller event handler 
#undef TBApiGetRawEventState 
#ifdef TBAPIDLLPFX 
#define TBApiGetRawEventState DLL_TBApiGetRawEventState
#endif 

BOOL TBAPI TBApiGetRawEventState(HTBDEVICE aDeviceHandle, int aEventHandle, BOOL* aState);

// does the settings cache have unwritten changes?
#undef TBApiSettingsCacheDirty 
#ifdef TBAPIDLLPFX 
#define TBApiSettingsCacheDirty DLL_TBApiSettingsCacheDirty
#endif 

BOOL TBAPI TBApiSettingsCacheDirty(); 

// get the default value of the specified setting
#undef TBApiGetDefaultSZ 
#ifdef TBAPIDLLPFX 
#define TBApiGetDefaultSZ DLL_TBApiGetDefaultSZ
#endif 

BOOL TBAPI TBApiGetDefaultSZ(HTBDEVICE aDeviceHandle,const TBCHAR* aName, TBCHAR* aSZ, int lBuff);
#undef TBApiGetDefaultDWORD 
#ifdef TBAPIDLLPFX 
#define TBApiGetDefaultDWORD DLL_TBApiGetDefaultDWORD
#endif 

BOOL TBAPI TBApiGetDefaultDWORD(HTBDEVICE aDeviceHandle,const TBCHAR* aName, unsigned long* val);

// Generate a clone data file for use during automated setup
/*#undef TBApiClone 
#ifdef TBAPIDLLPFX 
#define TBApiClone DLL_TBApiClone
#endif 

BOOL TBAPI TBApiClone(HTBDEVICE aDevice, const TBCHAR* aFile);*/

// get a value from the controller definition (<driver>\Controller\TSnnn) 
//BOOL TBApiGetControllerSZ(GUID aControllerId,const TBCHAR* aName, TBCHAR* aSZ, int lBuff);
//BOOL TBApiGetControllerDWORD(GUID aControllerId,const TBCHAR* aName, DWORD* aValue);
#undef TBApiGetControllerSZ 
#ifdef TBAPIDLLPFX 
#define TBApiGetControllerSZ DLL_TBApiGetControllerSZ
#endif 

BOOL TBAPI TBApiGetControllerSZ(int aControllerKey,const TBCHAR* aName, TBCHAR* aSZ, int lBuff);
#undef TBApiGetControllerDWORD 
#ifdef TBAPIDLLPFX 
#define TBApiGetControllerDWORD DLL_TBApiGetControllerDWORD
#endif 

BOOL TBAPI TBApiGetControllerDWORD(int aControllerKey,const TBCHAR* aName, DWORD* aValue);

// queue a request for deletion of a registry branch to be effected in sequence at "apply" time 
#undef TBApiRegDeleteBranchCached 
#ifdef TBAPIDLLPFX 
#define TBApiRegDeleteBranchCached DLL_TBApiRegDeleteBranchCached
#endif 

BOOL TBAPI TBApiRegDeleteBranchCached(void* hRootKey,const TBCHAR*  lpSubKey);

// get the active help file name, based on current customisation and language
#undef TBApiGetHelpFileName 
#ifdef TBAPIDLLPFX 
#define TBApiGetHelpFileName DLL_TBApiGetHelpFileName
#endif 

void TBAPI TBApiGetHelpFileName(char* aFileName, int aMaxLength);

/*#undef TBApiInternalGetBundle 
#ifdef TBAPIDLLPFX 
#define TBApiInternalGetBundle DLL_TBApiInternalGetBundle
#endif 

HTBBUNDLE TBAPI TBApiInternalGetBundle(const TBCHAR* aGuid);*/

// Sound the beep as defined by the device sound pitch and duration settings
//BOOL TBApiBeep(int aDeviceId);

/*#ifdef INTERNALAPI
#define TBApiGetBundle ""
#else
#include "tbbundle.h"
#define TBApiGetBundle() TBApiInternalGetBundle(BUNDLE_GUID)
#endif

#undef TBApiGetActiveBundleGUID 
#ifdef TBAPIDLLPFX
#define TBApiGetActiveBundleGUID  DLL_TBApiGetActiveBundleGUID 
#endif

const TBCHAR* TBAPI TBApiGetActiveBundleGUID();*/

// examine the recorded calibration points for a device to see if "SwapXY" is incorrectly set
// if so set SwapXY correctly and reverse  correct the recorded co-ordinates
// a calibration should call this after the raw co-ordinates have been stored 
// to ensure this property is correctly set 

// this api can only function if at least 2 calibration points share the same 
// Y axis. FALSE is returned if this is not the case
#undef TBApiAutoSetSwapXY 
#ifdef TBAPIDLLPFX 
#define TBApiAutoSetSwapXY DLL_TBApiAutoSetSwapXY
#endif 

BOOL  TBAPI TBApiAutoSetSwapXY(HTBDEVICE aDevice);

// get the x-cordinate range determined from the packet size(s)
#undef TBApiGetMaxX 
#ifdef TBAPIDLLPFX 
#define TBApiGetMaxX DLL_TBApiGetMaxX
#endif 

BOOL  TBAPI TBApiGetMaxX(HTBDEVICE aDevice, DWORD* aX);

// get the y-cordinate range determined from the packet size(s)
#undef TBApiGetMaxY 
#ifdef TBAPIDLLPFX 
#define TBApiGetMaxY DLL_TBApiGetMaxY
#endif 

BOOL  TBAPI TBApiGetMaxY(HTBDEVICE aDevice, DWORD* aY);

// Instruct registered applications to terminate 
// used by setup programs to unlock program files during install
#undef TBApiSendUnloadMessage 
#ifdef TBAPIDLLPFX 
#define TBApiSendUnloadMessage DLL_TBApiSendUnloadMessage
#endif 

BOOL TBAPI TBApiSendUnloadMessage();

//#ifdef RECT 
//// get the size and position of the specified monitor
//#undef TBApiGetPrimaryMonitor 
//#endif
//#ifdef TBAPIDLLPFX 
//#define TBApiGetPrimaryMonitor DLL_TBApiGetPrimaryMonitor
//#endif 
//
//bool TBAPI TBApiGetPrimaryMonitor(char *aBuff);
//
//
//#ifdef RECT 
//// get the size and position of the specified monitor
//#undef TBApiGetMonitorPlacement 
//#ifdef TBAPIDLLPFX 
//#define TBApiGetMonitorPlacement DLL_TBApiGetMonitorPlacement
//#endif 
//BOOL TBAPI TBApiGetMonitorPlacement(int aMonitor, RECT& aPlacement);
//#endif


 

// get the iProduct item from the associated USB device 
// return false if 
// 1 - not a usb device 
// 2 - aDevice does not exist 
// 3 - device has not been started 

#undef TBApiGetIProduct 
#ifdef TBAPIDLLPFX 
#define TBApiGetIProduct DLL_TBApiGetIProduct
#endif 

BOOL  TBAPI TBApiGetIProduct(HTBDEVICE aDevice, DWORD* aValue);

#undef TBApiDeleteRegistryValueCached 
#ifdef TBAPIDLLPFX 
#define TBApiDeleteRegistryValueCached DLL_TBApiDeleteRegistryValueCached
#endif 

void TBAPI TBApiDeleteRegistryValueCached(void* aKey, LPCTSTR aPath,LPCTSTR aValueName);

// Remove the UPDD device definition and any corresponding Windows device entry
#undef TBApiRemoveDevice 
#ifdef TBAPIDLLPFX 
#define TBApiRemoveDevice DLL_TBApiRemoveDevice
#endif 

BOOL  TBAPI TBApiRemoveDevice(int aControllerKey);

#undef TBApiRecordMousePosition 
#ifdef TBAPIDLLPFX 
#define TBApiRecordMousePosition DLL_TBApiRecordMousePosition
#endif 

BOOL TBAPI TBApiRecordMousePosition(unsigned long x, unsigned long y);

#undef TBApiSetDrawState 
#ifdef TBAPIDLLPFX 
#define TBApiSetDrawState DLL_TBApiSetDrawState
#endif 

#define DRAW_FOREGROUND   1
#define DRAW_MINIMISED  2
#define DRAW_TOOLBAR_VISIBLE   4
#define DRAW_VISIBLE   8

BOOL TBAPI TBApiSetDrawState(unsigned aState);

#undef TBApiGetDrawState 
#ifdef TBAPIDLLPFX 
#define TBApiGetDrawState DLL_TBApiGetDrawState
#endif 

BOOL TBAPI TBApiGetDrawState(unsigned* aState);

#undef TBApiSetMorphState 
#ifdef TBAPIDLLPFX 
#define TBApiSetMorphState DLL_TBApiSetMorphState
#endif 

BOOL TBAPI TBApiSetMorphState(unsigned aState);

#undef TBApiGetMorphState 
#ifdef TBAPIDLLPFX 
#define TBApiGetMorphState DLL_TBApiGetMorphState
#endif 

BOOL TBAPI TBApiGetMorphState(unsigned* aState);

#undef TBApiPostIPConnection
#ifdef TBAPIDLLPFX  
#define TBApiPostIPConnection DLL_TBApiPostIPConnection
#endif  

BOOL TBAPI TBApiPostIPConnection(const char* aHostname, const char *aIPAddress);
 
#undef TBApiPostPacketBytes 
#ifdef TBAPIDLLPFX 
#define TBApiPostPacketBytes DLL_TBApiPostPacketBytes
#endif 

BOOL TBAPI TBApiPostPacketBytes(HTBDEVICE aDevice, unsigned char* aData, unsigned aNBytes);
////////////////////////////////////////////////////////////////////////////////////////////////////

/// Stencils API group 
///
/// The purpose of this API group is to allow a means by which an application
/// can finely tune where a user may interact with an application via the touch interface 
///
/// To allow total control there are two types of stencil. 
/// 
/// 1) Normal, this identifies a usable area of the screen, If a user touches a point in a nomal stencil the touch is passed through (for example to the system mouse) as normal
/// 2) Inverted, this identifies a unusable area of the screen,  If a user touches a point in a normal stencil the touch is blocked 
///     (although registered callbacks are still sent for this touch) 
///
/// Stencils are order based so the topmost (last defined) stencil at a given point is used 
///
/// In the example below stencil 0 is defined first  
/// 
/// A touch at point A is accepted (because it is outside any stencil) 
/// A touch at point B is not accepted (because it is inside inverted stencil 0) 
/// A touch at point C is accepted (because it is inside normal stencil 1, the touch is also inside stencil 0 but stencil 1 takes priority as it was defined later) 
/// 
///             ----  stencil 0 -(inverted)  ------------------------------------------------
///     A      |                                                                             |
///            |                ---- stencil 1 (normal)-------------                         |
///            |               |                                    |                        |
///            |        B      |                                    |                        |
///            |               |                C                   |                        |
///            |                ------------------------------------                         |
///            |                                                                             |
///             -----------------------------------------------------------------------------
///
////////////////////////////////////////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////////////////////////////////////////////
/// Enables or disables stencils 
/// If stencils are enabled, then only areas inside of stencils will be active, or outside if the stencil is inverted 
///
/// @param       aEnable     TRUE to enable, FALSE to disable
////////////////////////////////////////////////////////////////////////////////////////////////////
#undef TBApiEnableStencils
#ifdef TBAPIDLLPFX  
#define TBApiEnableStencils DLL_TBApiEnableStencils
#endif  
BOOL TBAPI TBApiEnableStencils(BOOL aEnable);

////////////////////////////////////////////////////////////////////////////////////////////////////
/// Adds a new stencil to the stencil list 
///
/// @return      a handle to the new stencil - TB_INVALID_HANDLE_VALUE if a failure occured
////////////////////////////////////////////////////////////////////////////////////////////////////
#undef TBApiAddStencil
#ifdef TBAPIDLLPFX  
#define TBApiAddStencil DLL_TBApiAddStencil
#endif  
HTBSTENCIL TBAPI TBApiAddStencil();

////////////////////////////////////////////////////////////////////////////////////////////////////
/// Removes all stencils from the stencil list 
///
////////////////////////////////////////////////////////////////////////////////////////////////////
#undef TBApiRemoveStencils
#ifdef TBAPIDLLPFX  
#define TBApiRemoveStencils DLL_TBApiRemoveStencils
#endif  
BOOL TBAPI TBApiRemoveStencils();

////////////////////////////////////////////////////////////////////////////////////////////////////
/// Marks a stencil as inverted
///
/// @param       aStencil    handle returned by TBApiAddStencil
////////////////////////////////////////////////////////////////////////////////////////////////////
#undef TBApiSetStencilInverted
#ifdef TBAPIDLLPFX  
#define TBApiSetStencilInverted DLL_TBApiSetStencilInverted
#endif  
BOOL TBAPI TBApiSetStencilInverted(HTBSTENCIL aStencil);

////////////////////////////////////////////////////////////////////////////////////////////////////
/// Sets the stencils location on the screen.
/// All coordinates are in UPDD logical screen coordinates (where the primary monitor is 0-65535 x 0-65535 ) 
///
/// @param       aStencil    handle returned by TBApiAddStencil
////////////////////////////////////////////////////////////////////////////////////////////////////
#undef TBApiSetStencilPos
#ifdef TBAPIDLLPFX  
#define TBApiSetStencilPos DLL_TBApiSetStencilPos
#endif  
BOOL TBAPI TBApiSetStencilPos(HTBSTENCIL aStencil, long left, long top, long right, long bottom );

//////////////////////////////////////////////////////////////////////////////////////////////////////
///// Write EEPROM values to a TSHARC controller
/////
//////////////////////////////////////////////////////////////////////////////////////////////////////
//BOOL TBAPI TBApiWriteTSHARCEEPROM(HTBDEVICE aDevice, const void* aBuffer, DWORD aSize);
//
//////////////////////////////////////////////////////////////////////////////////////////////////////
///// Read EEPROM values from a TSHARC controller
/////
//////////////////////////////////////////////////////////////////////////////////////////////////////
//BOOL TBAPI TBApiReadTSHARCEEPROM(HTBDEVICE aDevice, void* aBuffer, DWORD aSize);

////////////////////////////////////////////////////////////////////////////////////////////////////
/// Read serial number from device
///
////////////////////////////////////////////////////////////////////////////////////////////////////
void TBAPI TBApiReadSerialNumber(HTBDEVICE aDevice, TBCHAR *aBuf, DWORD aSize);

////////////////////////////////////////////////////////////////////////////////////////////////////
/// Gets the address of a device on the USB bus
///
////////////////////////////////////////////////////////////////////////////////////////////////////
DWORD TBAPI TBApiGetUSBDeviceAddress(HTBDEVICE aDevice);

////////////////////////////////////////////////////////////////////////////////////////////////////
/// Set the value of the serial number for a smartset device
///
////////////////////////////////////////////////////////////////////////////////////////////////////
BOOL TBAPI TBApiWriteSmartsetUSBSerialNumber(HTBDEVICE aDevice, const TBCHAR* aBuffer, DWORD aSize);

////////////////////////////////////////////////////////////////////////////////////////////////////
/// Get the value of the serial number for a smartset device
///
////////////////////////////////////////////////////////////////////////////////////////////////////
BOOL TBAPI TBApiReadSmartsetUSBSerialNumber(HTBDEVICE aDevice, TBCHAR* aBuffer, DWORD aSize);


////////////////////////////////////////////////////////////////////////////////////////////////////
/// Save the named toolbar for the device
///
////////////////////////////////////////////////////////////////////////////////////////////////////
BOOL TBAPI TBApiSaveToolbar(HTBDEVICE aDevice, DWORD aToolbar, const TBCHAR *aFileName);

////////////////////////////////////////////////////////////////////////////////////////////////////
/// Load a toolbar from a file for the named device
///
////////////////////////////////////////////////////////////////////////////////////////////////////
BOOL TBAPI TBApiLoadToolbar(HTBDEVICE aDevice, const TBCHAR *aFileName, int *aTBNum);

////////////////////////////////////////////////////////////////////////////////////////////////////
/// Enable / disable toolbar
///
////////////////////////////////////////////////////////////////////////////////////////////////////
BOOL TBAPI TBApiEnableToolbar(HTBDEVICE aDevice, TBCHAR *aToolbar, BOOL aEnable);

////////////////////////////////////////////////////////////////////////////////////////////////////
/// register api application with UPDD
///
////////////////////////////////////////////////////////////////////////////////////////////////////
#undef TBApiRegisterApplication
#ifdef TBAPIDLLPFX  
#define TBApiRegisterApplication DLL_TBApiRegisterApplication
#endif  
BOOL TBAPI TBApiRegisterApplication(TBCHAR *aApplication);
////////////////////////////////////////////////////////////////////////////////////////////////////
/// get the position of the primary monitor 
/// and the position and size of a monitor associated with a specified updd device 
////////////////////////////////////////////////////////////////////////////////////////////////////
#undef TBApiGetMonitorMetrics
#ifdef TBAPIDLLPFX  
#define TBApiGetMonitorMetrics DLL_TBApiGetMonitorMetrics
#endif  
void TBAPI TBApiGetMonitorMetrics(unsigned aDevice,
                                  long* aPrimaryMonitorWidth, long* aPrimaryMonitorHeight,
                                  long* aMonitorWidth, long* aMonitorHeight, long* aMonitorLeft, long* aMonitorTop);

////////////////////////////////////////////////////////////////////////////////////////////////////
/// get the  position and size of a monitor 
////////////////////////////////////////////////////////////////////////////////////////////////////
#undef TBApiGetMonitorMetricsForMonitor
#ifdef TBAPIDLLPFX  
#define TBApiGetMonitorMetricsForMonitor DLL_TBApiGetMonitorMetricsForMonitor
#endif  

BOOL TBAPI TBApiGetMonitorMetricsForMonitor(unsigned aMonitor,
                                            long* aMonitorWidth, long* aMonitorHeight, long* aMonitorLeft, long* aMonitorTop);

////////////////////////////////////////////////////////////////////////////////////////////////////
/// given a co-ordinate in screen pixels (relative to the origin of the primary monitor) 
/// return the UPDD co-ordinate (65535 based) 
////////////////////////////////////////////////////////////////////////////////////////////////////
#undef TBApiUPDDCoordinateFromScreen
#ifdef TBAPIDLLPFX  
#define TBApiUPDDCoordinateFromScreen DLL_TBApiUPDDCoordinateFromScreen
#endif  
BOOL TBAPI TBApiUPDDCoordinateFromScreen( long aScreenX, long aScreenY, 
                                        long* aUPDDX, long* aUPDDY);

////////////////////////////////////////////////////////////////////////////////////////////////////
/// enable / disable mouse event filtering  
/// with mouse event filtering in effect mouse events are not passsed to the O/S for processing.
/// such events can be received using _ReadDataTypeMouseEvent
/// and after filtering injected with TBApiInjectMouseEvent 
////////////////////////////////////////////////////////////////////////////////////////////////////
#undef TBApiEnableMouseEventFilter
#ifdef TBAPIDLLPFX  
#define TBApiEnableMouseEventFilter DLL_TBApiEnableMouseEventFilter
#endif  
BOOL TBAPI TBApiEnableMouseEventFilter(HTBDEVICE aDevice, BOOL aEnable); 

////////////////////////////////////////////////////////////////////////////////////////////////////
/// inject a mouse event for processing via the operating system mouse interface 
////////////////////////////////////////////////////////////////////////////////////////////////////
#undef TBApiInjectMouseEvent
#ifdef TBAPIDLLPFX  
#define TBApiInjectMouseEvent DLL_TBApiInjectMouseEvent
#endif  
BOOL TBAPI TBApiInjectMouseEvent(HTBDEVICE aDevice, struct _mouseEvent* aMouseEvent); 

////////////////////////////////////////////////////////////////////////////////////////////////////
/// read eeprom data for the controller (must have a supported eeprom protocol)  
////////////////////////////////////////////////////////////////////////////////////////////////////
#undef TBApiReadEEPROM
#ifdef TBAPIDLLPFX  
#define TBApiReadEEPROM DLL_TBApiReadEEPROM
#endif  
BOOL  TBAPI TBApiReadEEPROM(HTBDEVICE aDevice, DWORD aStartAddress, DWORD aLength, void* aData, int aMaxValidations);

////////////////////////////////////////////////////////////////////////////////////////////////////
/// write eeprom data for the controller (must have a supported eeprom protocol)  
////////////////////////////////////////////////////////////////////////////////////////////////////
#undef TBApiWriteEEPROM
#ifdef TBAPIDLLPFX  
#define TBApiWriteEEPROM DLL_TBApiWriteEEPROM
#endif  
BOOL  TBAPI TBApiWriteEEPROM(HTBDEVICE aDevice, DWORD aStartAddress, DWORD aLength, void* aData, int aMaxValidations);

////////////////////////////////////////////////////////////////////////////////////////////////////
/// get extended info about an api error, currently only applicable to  TBApiReadEEPROM / TBApiWriteEEPROM

////////////////////////////////////////////////////////////////////////////////////////////////////
#undef TBApiGetLastError
#ifdef TBAPIDLLPFX  
#define TBApiGetLastError DLL_TBApiGetLastError
#endif  

void TBAPI TBApiGetLastError(TBCHAR* aMsg, int aMaxLength);

#endif // DRIVERSTRINGS

#ifdef __cplusplus
} // extern "C"
#endif

#ifdef TBAPIDLL_EXPORTS 
#pragma warning(default:4518)
#endif



#endif







